/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;

public final class ModVillageStructures {
    private ModVillageStructures() {
    }

    public static void addVillageStructures() {
        if (!ModCfg.enableStructures()) {
            return;
        }
        ParagliderMod.LOGGER.debug("Start adding village structures");
        ModVillageStructures.appendPool(new ResourceLocation("village/desert/houses"), a -> {
            a.append(JigsawPiece.func_242849_a((String)"paraglider:gerudo_village_goddess_statue"), 1);
            a.append(JigsawPiece.func_242849_a((String)"paraglider:desert_village_horned_statue"), 1);
        });
        ModVillageStructures.appendPool(new ResourceLocation("village/plains/houses"), a -> {
            a.append(JigsawPiece.func_242849_a((String)"paraglider:hateno_village_goddess_statue"), 1);
            a.append(JigsawPiece.func_242849_a((String)"paraglider:plains_village_horned_statue"), 1);
        });
        ModVillageStructures.appendPool(new ResourceLocation("village/savanna/houses"), a -> {
            a.append(JigsawPiece.func_242849_a((String)"paraglider:rito_village_goddess_statue"), 3);
            a.append(JigsawPiece.func_242849_a((String)"paraglider:savanna_village_horned_statue"), 1);
        });
        ModVillageStructures.appendPool(new ResourceLocation("village/snowy/houses"), a -> a.append(JigsawPiece.func_242849_a((String)"paraglider:snowy_village_horned_statue"), 1));
        ModVillageStructures.appendPool(new ResourceLocation("village/taiga/houses"), a -> {
            a.append(JigsawPiece.func_242849_a((String)"paraglider:kakariko_village_goddess_statue"), 3);
            a.append(JigsawPiece.func_242849_a((String)"paraglider:taiga_village_horned_statue"), 1);
        });
        ParagliderMod.LOGGER.debug("Finished adding village structures");
    }

    private static void appendPool(ResourceLocation pool, Consumer<PoolAppender> c) {
        JigsawPattern old = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(pool);
        if (old == null || old == JigsawPatternRegistry.func_244093_a()) {
            ParagliderMod.LOGGER.warn("Jigsaw pool '{}' doesn't exists", (Object)pool);
            return;
        }
        PoolAppender appender = new PoolAppender();
        c.accept(appender);
        if (appender.structureToWeight.isEmpty()) {
            return;
        }
        ArrayList newWeightedPool = new ArrayList();
        newWeightedPool.addAll(old.field_214952_d);
        newWeightedPool.addAll(appender.structureToWeight);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243656_h, (ResourceLocation)pool, (Object)new JigsawPattern(pool, old.func_214947_b(), newWeightedPool));
        ParagliderMod.LOGGER.debug("Added {} elements to jigsaw pool '{}'", (Object)appender.structureToWeight.size(), (Object)pool);
    }

    private static final class PoolAppender {
        private final List<Pair<JigsawPiece, Integer>> structureToWeight = new ArrayList<Pair<JigsawPiece, Integer>>();

        private PoolAppender() {
        }

        public void append(Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece> factory, int weight) {
            this.structureToWeight.add((Pair<JigsawPiece, Integer>)new Pair((Object)factory.apply(JigsawPattern.PlacementBehaviour.RIGID), (Object)weight));
        }
    }
}

